<?php
require_once __DIR__ . '/../config/db.php';

try {
    // First, check the current column definition
    $check_sql = "SHOW COLUMNS FROM supplier_receipts LIKE 'payment_status'";
    $result = $pdo->query($check_sql);
    $column_info = $result->fetch(PDO::FETCH_ASSOC);
    
    if ($column_info) {
        echo "Current payment_status column definition: " . $column_info['Type'] . "\n";
    }
    
    // Update the payment_status column to include 'added_to_stock'
    $sql = "ALTER TABLE supplier_receipts 
            MODIFY COLUMN payment_status ENUM('pending', 'paid', 'credit', 'added_to_stock') DEFAULT 'pending'";
    
    $pdo->exec($sql);
    echo "✅ Updated payment_status column in supplier_receipts table to include 'added_to_stock'!\n";
    
    // Verify the update
    $check_sql = "SHOW COLUMNS FROM supplier_receipts LIKE 'payment_status'";
    $result = $pdo->query($check_sql);
    $column_info = $result->fetch(PDO::FETCH_ASSOC);
    
    if ($column_info) {
        echo "New payment_status column definition: " . $column_info['Type'] . "\n";
    }
    
} catch (PDOException $e) {
    echo "❌ Error updating payment_status column: " . $e->getMessage() . "\n";
    exit(1);
}

echo "🎉 Migration completed successfully!\n";
?> 